<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class WheelConfigs extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        
        Schema::create('wheel_configs', function (Blueprint $table) {
            $table->increments('id');
           
            $table->string("colorArray")->default('["#364C62", "#F1C40F", "#E67E22", "#E74C3C"]');
            $table->string("gameId")->default("9azzza0232ec06bc431114e2a7f3aea03bbe2164f1aa");
            $table->string("invalidSpinText")->default("Invalide, merci de réessayer!");
            $table->string("gameOverText")->default("Merci!");
            $table->string("introText")->default("Let\'s Go");
            $table->string("centerCircleStrokeColor")->default("#F1DC15");
            $table->string("centerCircleFillColor")->default("#EDEDED");
            $table->string("segmentStrokeColor")->default("#E2E2E2");
            $table->string("wheelStrokeColor")->default("#D0BD0C");
            $table->string("wheelTextColor")->default("#EDEDED");
            $table->string("wheelTextSize")->default("2.3em");
            $table->string("spinDestinationArray")->default("[]");
            $table->double("wheelImageOffsetY")->default(20);
            $table->double("wheelStrokeWidth")->default(18);
            $table->double("wheelTextOffsetY")->default(80);
            $table->double("svgWidth")->default(1024);
            $table->double("svgHeight")->default(768);
            $table->double("wheelSize")->default(700);
            $table->double("wheelImageSize")->default(120);
            $table->double("centerCircleSize")->default(360);
            $table->double("centerCircleStrokeWidth")->default(12);
            $table->double("segmentStrokeWidth")->default(4);
            $table->double("centerX")->default(512);
            $table->double("centerY")->default(384);
            $table->double("numSpins")->default(1);
            $table->double("minSpinDuration")->default(6);
            $table->boolean("hasShadows")->default(false);
            $table->boolean("hasSound")->default(true);
            $table->boolean("clickToSpin")->default(true);

            $table->timestamps();
           
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        DB::statement('SET FOREIGN_KEY_CHECKS = 0');
        Schema::dropIfExists('wheel_configs');
        DB::statement('SET FOREIGN_KEY_CHECKS = 1');
    }
}
