<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Reward;
use App\WheelConfig;

class WheelDataController extends Controller
{

    function wheelData()
    {
    	$data = WheelConfig::first();
        $rewards = Reward::all();
        
        foreach ($rewards as $value) {
            $value['userData'] = $value['id'];
        }
        

        $jsonFile = base_path()."/reward_winner.json" ;
        $json = json_decode(file_get_contents($jsonFile));
       
        if (count($json->rewards)) {
            foreach ($rewards as $key => $reward) {
                $reward->probability = 0;
                if ($reward->intitule == $json->rewards[0]) {
                    $reward->probability = 100;
                }
            }
        }

        $json->rewards = [];
        $json = json_encode($json);
        file_put_contents($jsonFile, $json);

        $data["segmentValuesArray"] = $rewards;


        $data = collect($data)->map(function($item, $key){
            if (json_decode($item)) {
                $item = json_decode($item);
            }
            return $item;
        });


       


		return $data;
    }
}
