<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use ReCaptcha\ReCaptcha;
use App\Mail\winner;
use App\WheelConfig;
use App\Magasin;
use App\Ville;
use Validator;
use App\User;
use App\Win;
use Auth;
use Mail;

class HomeController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        if (!WheelConfig::first()) {
            $w = new WheelConfig();
            $w->save();
        }
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        return view('home');
    }
    
    public function welcomeData()
    {
        return ['magasins'=> Magasin::all(),'villes'=> Ville::all()];
    }   
    public function welcome()
    {
        return view('welcome',['magasins'=> Magasin::all(),'villes'=> Ville::all()]);
    }

    public function getCode(Request $data)
    {
        
        $user = User::where('api_token',$data->api_token)->first();

        $win = Win::where('user_id',$user->id)->first();
        if ($win) {
            return response(['code'=> $win->code],200);
        }

        return response('not found', 404);

    }
        
    public function Spin2WinResult(Request $data)
    {
        $this->validate($data,[
            'reward' => 'required',
            ]);

        $codes = Win::pluck('code')->all();

        do{
            $code = rand(10000,9999999999);
        }while(in_array($code, $codes));

        $win = new Win();
        $win->user_id = Auth::user()->id;
        $win->reward_id = $data->reward;
        $win->code = $code;
        $win->save();

     //   Mail::to($win->user->email)->send(new winner($win, $win->user, $win//->reward));

        return response(200);
    }

    public function register(Request $data)
    {

        // $response = $data['g-recaptcha-response'];
        // $remoteip = $_SERVER['REMOTE_ADDR'];
        // $secret   = env('RE_CAP_SECRET');

        // $recaptcha = new ReCaptcha($secret);
        // $resp = $recaptcha->verify($response, $remoteip);
        
        // if ($resp->isSuccess()) {
        //     $data['captcha'] = 1;
        // } else {
        //     return response(['captcha'=>'captcha not verified'],422);
        // }
     
        $this->validateUser($data);

        if($this->isUserRegistered($data)){

            abort(403, 'Unauthorized action.');

        }else{
            $user = $this->registerUser($data);
            return response(['api_token' => $user->api_token],200);
        }

    }
    
    protected function registerUser($data)
    {
        
        $tokens = User::pluck('api_token')->all();

        do{
            $token = str_random(10);
        }while(in_array($token, $tokens));

        $user = new User();
        $user->name = $data->name;
        $user->email = $data->email;
        $user->tel = $data->tel;
        $user->api_token = $token;
        $user->ville_id = (int)$data->ville;
        $user->magasin_id = (int)$data->magasin;
        $user->save();

        Auth::guard('web')->login($user);

        return $user;
        
    }

    protected function validateUser($data)
    {

        $this->validate($data,[
            'name' => 'required',
            'tel' => 'required|numeric|min:10',
            'ville' => 'required',
        ]);
    }

    protected function isUserRegistered($data)
    {
        $validator = Validator::make($data->all(), [
            //'email' => 'unique:users',
            'tel' => 'unique:users',
        ]);

        if ($validator->fails()) {
            return true;
        }
        return false;
    }
   
}
